﻿using Hims.Api.Models;
using Hims.Api.Utilities;
using Hims.Domain.Services;
using Hims.Shared.DataFilters;
using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.UserModels;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Hims.Api.Controllers
{

    /// <inheritdoc />
    [Authorize]
    [Route("api/birth-certificate")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class BirthCertificateController : BaseController
    {
        /// <summary>
        /// The idproof services.
        /// </summary>
        private readonly IBirthCertificateService birthCertificateService;


        /// <inheritdoc />
        public BirthCertificateController(IBirthCertificateService birthCertificateService)
        {
            this.birthCertificateService = birthCertificateService;
        }
        /// <summary>
        /// Inserts the hoc asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("add")]
        public async Task<ActionResult> InsertAsync([FromBody] BirthCertificateModel model)
        {
            model = (BirthCertificateModel)EmptyFilter.Handler(model);
            var response = await this.birthCertificateService.InsertAsync(model);
            return Success(response);
        }
        /// <summary>
        /// Inserts the hoc asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch")]
        public async Task<ActionResult> FetchAsync([FromBody] BirthCertificateModel model)
        {
            model = (BirthCertificateModel)EmptyFilter.Handler(model);
            var response = await this.birthCertificateService.FetchAllAsync(model);
            return Success(response);
        }

        /// <summary>
        /// Inserts the hoc asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch-birth-report")]
        public async Task<ActionResult> FetchBirthReportAsync([FromBody] BirthCertificateModel model)
        {
            model = (BirthCertificateModel)EmptyFilter.Handler(model);
            var response = await this.birthCertificateService.FetchBirthReportAsync(model);
            return Success(response);
        }
    }
}

